<?php namespace JoshuaTayo\Fha\Components;

use Str;
use Cms\Classes\Page;
use Cms\Classes\ComponentBase;
use JoshuaTayo\Fha\Models\Service as ServiceModel;

class ServiceForms extends ComponentBase
{ 
	public $data;

	public function componentDetails()
    {
        return [
            'name'        => 'ServiceForms',
            'description' => 'Display Service Images on page'
        ];
    }

    public function defineProperties()
    {
        return [
            'slug' => [
                'title'       => 'Slug',
                'type'        => 'string',
                'default'     => '{{ :slug }}'
            ],
            'detailPage' => [
                'title'             => 'Post page',
                'type'              => 'dropdown',
                'group'             => 'Links',
                'options'           => $this->getPageOptions()
            ],
            'searchPage' => [
                'title'             => 'Search page',
                'type'              => 'dropdown',
                'group'             => 'Links',
                'options'           => $this->getPageOptions()
            ],
        ];
    }

    public function getPageOptions()
    {
        return Page::sortBy('baseFileName')->lists('baseFileName', 'baseFileName');
    }

    public function onRun()
    {
        $this->data = $this->page['data'] = $this->loadItem();
    }

    protected function loadItem()
    {

        $slug = $this->property('slug');
        $data = ServiceModel::isEnabled()->where('slug', $slug)->first();

        return $data;
    }
}