<?php namespace JoshuaTayo\Fha;

use Backend;
use System\Classes\PluginBase;
use JoshuaTayo\Fha\Controllers\Messages;

class Plugin extends PluginBase
{
    public function registerComponents()
    {
        return [
            '\JoshuaTayo\Fha\Components\Slider'    => 'slider',
            '\JoshuaTayo\Fha\Components\PropertyPriceList'    => 'propertypricelist',
            '\JoshuaTayo\Fha\Components\ServiceList'    => 'servicelist',
            '\JoshuaTayo\Fha\Components\GalleryList'    => 'gallerylist',
            '\JoshuaTayo\Fha\Components\GalleryImages'    => 'galleryimages',
            '\JoshuaTayo\Fha\Components\ProjectDetails'    => 'projectdetails',
            '\JoshuaTayo\Fha\Components\PartnerList'    => 'partnerlist',
            '\JoshuaTayo\Fha\Components\ContactForm'    => 'contactform',
        ];
    }

    public function registerMailTemplates()
    {
        return [
            'joshuatayo.fha::mail.reply' => 'Contact Form -- reply message',
            'joshuatayo.fha::mail.auto-response' => 'Contact Form -- auto response message',
            'joshuatayo.fha::mail.notification' => 'Contact Form -- notification mail',
        ];
    }

    public function registerSettings()
    {
        return [
            'settings' => [
                'label'         => 'FHA Settings',
                'description'   => 'About Fha configuration',
                'category'      => 'FHA Fontend Setting',
                'icon'          => 'icon-cog',
                'class'         => 'JoshuaTayo\Fha\Models\Settings',
                'order'         => 1
            ],
        ];
    }

    public function registerNavigation(){
        return [
            'messages' => [
                'label'       => 'Messages',
                'url'         => Backend::url('joshuatayo/fha/messages'),
                'icon'        => 'icon-envelope',

                'sideMenu' => [
                    'contactform' => [
                        'label'       => 'Contact Form',
                        'icon'        => 'icon-inbox',
                        'url'         => Backend::url('joshuatayo/fha/messages'),
                        'counter'     => Messages::countUnreadMessages(),
                        'counterLabel' => 'Un-Read Messages'
                    ]

                ]

            ]
        ];
    }
}
