<?php namespace October\Rain\Redis;

use Illuminate\Redis\RedisManager;
use Illuminate\Redis\RedisServiceProvider as BaseRedisServiceProvider;
use Illuminate\Support\Arr;

class RedisServiceProvider extends BaseRedisServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('redis', function ($app) {
            $config = $app->make('config')->get('database.redis', []);

            return new RedisManager($app, Arr::pull($config, 'client', 'predis'), $config);
        });

        $this->app->bind('redis.connection', function ($app) {
            return $app['redis']->connection();
        });
    }
}
