<?php

return [
    'plugin' => [
        'name' => 'Builder',
        'description' => 'Stelt visuele hulpmiddelen beschikbaar om October plugins te maken.',
        'add' => 'Maak plugin',
        'no_records' => 'Geen plugins aanwezig',
        'no_name' => 'Geen naam',
        'search' => 'Zoeken...',
        'filter_description' => 'Toon alle plugins of alleen eigen plugins.',
        'settings' => 'Instellingen',
        'entity_name' => 'Plugin',
        'field_name' => 'Naam',
        'field_author' => 'Auteur',
        'field_description' => 'Omschrijving',
        'field_icon' => 'Icoon',
        'field_plugin_namespace' => 'Plugin namespace',
        'field_author_namespace' => 'Auteur namespace',
        'field_namespace_description' => 'Een namespace kan alleen latijnse letters en cijfers bevatten en mag ook alleen met een letter beginnen. Bijvoorbeeld: Blog',
        'field_author_namespace_description' => 'Je kan de namespace van een Builder plugin niet meer wijzigen nadat je de plugin hebt gemaakt. Bijvoorbeeld: JohnSmith',
        'tab_general' => 'Algemeen',
        'tab_description' => 'Details',
        'field_homepage' => 'Plugin homepagina URL',
        'no_description' => 'Er is geen omschrijving opgegeven voor deze plugin.',
        'error_settings_not_editable' => 'De instellingen van deze plugin kunnen niet met Builder worden gewijzigd.',
        'update_hint' => 'Je kan de naam en omschrijving van de plugin vertalen in de \'Vertalen\' tab.',
    ],
    'author_name' => [
        'title' => 'Auteursnaam',
        'description' => 'Dit is de standaard auteursnaam die wordt gebruikt bij het maken van plugins. Deze naam staat niet vast, je kan hem altijd wijzigen in de instellingen van de plugin.',
    ],
    'author_namespace' => [
        'title' => 'Auteur namespace',
        'description' => 'Als je plugins maakt voor de Marketplace, dan moet de namespace gelijk zijn aan de auteur code en niet gewijzigd worden. Raadpleeg de documentatie voor aanvullende details.',
    ],
    'database' => [
        'menu_label' => 'Database',
        'no_records' => 'Geen database tabellen aanwezig',
        'search' => 'Zoeken...',
        'confirmation_delete_multiple' => 'Weet je zeker dat je de geselecteerde tabellen wilt verwijderen?',
        'field_name' => 'Tabelnaam',
        'tab_columns' => 'Kolommen',
        'column_name_name' => 'Kolom',
        'column_name_required' => 'Geef kolomnaam op',
        'column_name_type' => 'Type',
        'column_type_required' => 'Selecteer kolomtype',
        'column_name_length' => 'Lengte',
        'column_validation_length' => 'Lengte moet een getal zijn of een getal met dicimalen (10,2). Spaties zijn niet toegestaan.',
        'column_validation_title' => 'Alleen getallen, kleine letters en underscores zijn toegestaan in kolomnamen',
        'column_name_unsigned' => 'Unsigned',
        'column_name_nullable' => 'Nullable',
        'column_auto_increment' => 'AUTOINCR',
        'column_default' => 'Standaardwaarde',
        'column_auto_primary_key' => 'PK',
        'tab_new_table' => 'Nieuwe tabel',
        'btn_add_column' => 'Kolom toevoegen',
        'btn_delete_column' => 'Kolom verwijderen',
        'confirm_delete' => 'Do you really want to delete the table?',
        'error_enum_not_supported' => 'De tabel bevat kolom(men) van het type "enum", deze worden momenteel niet ondersteund door Builder.',
        'error_table_name_invalid_prefix' => "De tabelnaam moet starten met de plugin prefix: ':prefix'.",
        'error_table_name_invalid_characters' => 'Ongeldige tabelnaam. Tabelnamen mogen alleen latijnse letters, cijfers en underscores bevatten. Tabelnamen moeten beginnen met een letter en mogen geen spaties bevatten.',
        'error_table_duplicate_column' => "Kolomnaam bestaat reeds: ':column'.",
        'error_table_auto_increment_in_compound_pk' => 'Een `auto-increment` kolom kan geen deel uitmaken van een `compound primary key`.',
        'error_table_mutliple_auto_increment' => 'De tabel kan niet meerdere `auto-increment` kolommen bevatten.',
        'error_table_auto_increment_non_integer' => 'Auto-increment kolommen moeten van het type `integer` zijn.',
        'error_table_decimal_length' => "De lengte voor type `:type` moet voldoen aan het formaat '10,2', zonder spaties.",
        'error_table_length' => 'De lengte voor type `:type` moet als een integer worden gespecificeerd.',
        'error_unsigned_type_not_int' => "Fout gevonden in kolomdefinitie ':column'. De `unsigned` vlag mag alleen op type `integer` kolommen worden toegepast.",
        'error_integer_default_value' => "Ongeldige standaardwaarde voor kolom ':column'. Toegestane waardes zijn '10', '-10'.",
        'error_decimal_default_value' => "Ongeldige standaardwaarde voor kolom ':column'. Toegestane waardes zijn '1.00', '-1.00'.",
        'error_boolean_default_value' => "Ongeldige standaardwaarde voor kolom ':column'. Toegestane waardes zijn '0' and '1'.",
        'error_unsigned_negative_value' => "De standaardwaarde voor de kolom ':column' mag niet negatief zijn.",
        'error_table_already_exists' => "De tabel ':name' bestaat reeds in de database.",
    ],
    'model' => [
        'menu_label' => 'Models',
        'entity_name' => 'Model',
        'no_records' => 'Geen models aanwezig',
        'search' => 'Zoeken...',
        'add' => 'Toevoegen...',
        'forms' => 'Formulieren',
        'lists' => 'Lijsten',
        'field_class_name' => 'Klasse naam',
        'field_database_table' => 'Database tabel',
        'error_class_name_exists' => 'Model bestand bestaat reeds voor de opgegeven klasse naam: :path',
        'add_form' => 'Fomulier toevoegen',
        'add_list' => 'Lijst toevoegen',
    ],
    'form' => [
        'saved' => 'Het formulier is succesvol opgeslagen.',
        'confirm_delete' => 'Weet je zeker dat je het formulier wilt verwijderen?',
        'tab_new_form' => 'Nieuw formulier',
        'property_label_title' => 'Label',
        'property_label_required' => 'Voor waarde voor label in.',
        'property_span_title' => 'Uitlijning',
        'property_comment_title' => 'Toelichting',
        'property_comment_above_title' => 'Toelichting (boven)',
        'property_default_title' => 'Standaard',
        'property_checked_default_title' => 'Standaard aangevinkt',
        'property_css_class_title' => 'CSS klassenaam',
        'property_css_class_description' => 'Optionele CSS klassenaam die wordt toegewezen aan het veld element.',
        'property_disabled_title' => 'Uitgeschakeld',
        'property_hidden_title' => 'Verborgen',
        'property_required_title' => 'Verplicht',
        'property_field_name_title' => 'Veldnaam',
        'property_placeholder_title' => 'Tijdelijke aanduiding',
        'property_default_from_title' => 'Waarde van',
        'property_stretch_title' => 'Uitrekken',
        'property_stretch_description' => 'Geeft aan of dit veld uitrekt naar de breedte van het bovenliggende element.',
        'property_context_title' => 'Context',
        'property_context_description' => 'Geeft aan welk formulier context gebruikt moet worden om het veld weer te geven.',
        'property_context_create' => 'Aanmaken',
        'property_context_update' => 'Wijzigen',
        'property_context_preview' => 'Voorvertoning',
        'property_dependson_title' => 'Afhankelijk van',
        'property_trigger_action' => 'Actie',
        'property_trigger_show' => 'Weergeven',
        'property_trigger_hide' => 'Verbergen',
        'property_trigger_enable' => 'Inschakelen',
        'property_trigger_disable' => 'Uitschakelen',
        'property_trigger_empty' => 'Leeg',
        'property_trigger_field' => 'Veld',
        'property_trigger_field_description' => 'Geeft het veld aan wat de actie veroorzaakt.',
        'property_trigger_condition' => 'Voorwaarde',
        'property_trigger_condition_description' => 'Bepaald de voorwaarde waaraan het betreffende veld aan moet voldoen. Ondersteunde waarden: checked, unchecked, value[waarde].',
        'property_trigger_condition_checked' => 'Aangevinkt: checked',
        'property_trigger_condition_unchecked' => 'Uitgevinkt: unchecked',
        'property_trigger_condition_somevalue' => 'Waarde: value[waarde]',
        'property_preset_title' => 'Voorinstelling',
        'property_preset_description' => 'Zorgt ervoor dat de veldwaarde initieel wordt gevuld met de waarde van een ander veld, al dan niet geconverteerd.',
        'property_preset_field' => 'Veld',
        'property_preset_field_description' => 'Het veld waarvan de waarde moet overgenomen worden.',
        'property_preset_type' => 'Type',
        'property_preset_type_description' => 'Conversie type',
        'property_attributes_title' => 'Attributen',
        'property_attributes_description' => 'Custom HTML attributen die aan het formulier veld moeten worden toegevoegd.',
        'property_container_attributes_title' => 'Container attributen',
        'property_container_attributes_description' => 'Custom HTML attributen die aan het formulier veld container moeten worden toegevoegd.',
        'property_group_advanced' => 'Geavanceerd',
        'property_dependson_description' => 'Een lijst van veldnamen waar dit veld van afhankelijk is. Als die velden een andere waarde krijgen, zal dit veld worden bijgewerkt. Een veld per regel.',
        'property_trigger_title' => 'Trigger',
        'property_trigger_description' => 'Zorgt ervoor dat veld eigenschappen veranderen, zoals bijvoorbeeld zichtbaarheid of waarde, gebaseerd op de staat van een ander veld.',
        'property_default_from_description' => 'Neemt de standaardwaarde over van een ander veld.',
        'property_field_name_required' => 'Veldnaam is verplicht',
        'property_field_name_regex' => 'Veldnaam kan alleen latijnse karakters bevatten of _ - [ ] .',
        'property_attributes_size' => 'Grootte',
        'property_attributes_size_tiny' => 'Kleiner',
        'property_attributes_size_small' => 'Klein',
        'property_attributes_size_large' => 'Groter',
        'property_attributes_size_huge' => 'Groot',
        'property_attributes_size_giant' => 'Grootst',
        'property_comment_position' => 'Toelichting positie',
        'property_comment_position_above' => 'Boven',
        'property_comment_position_below' => 'Beneden',
        'property_hint_path' => 'Pad naar hint-sjabloon',
        'property_hint_path_description' => 'Pad naar sjabloon bestand die de hint tekst bevat. Gebruik het $ symbool om het hoofdpad van de plugin aan te geven. Voorbeeld: $/acme/blog/partials/_partial.htm',
        'property_hint_path_required' => 'Geef het hint-sjabloon pad op',
        'property_partial_path' => 'Pad naar sjabloon',
        'property_partial_path_description' => 'Pad naar sjabloon bestand. Gebruik het $ symbool om het hoofdpad van de plugin aan te geven. Voorbeeld: $/acme/blog/partials/_partial.htm',
        'property_partial_path_required' => 'Geef het sjabloon pad op',
        'property_code_language' => 'Taal',
        'property_code_theme' => 'Thema',
        'property_theme_use_default' => 'Gebruik standaard thema',
        'property_group_code_editor' => 'Code editor',
        'property_gutter' => 'Goot',
        'property_gutter_show' => 'Weergeven',
        'property_gutter_hide' => 'Verbergen',
        'property_wordwrap' => 'Woordafbreking',
        'property_wordwrap_wrap' => 'Afbreken',
        'property_wordwrap_nowrap' => 'Niet afbreken',
        'property_fontsize' => 'Grootte lettertype',
        'property_codefolding' => 'Code inklappen',
        'property_codefolding_manual' => 'Handmatig',
        'property_codefolding_markbegin' => 'Begin markeren',
        'property_codefolding_markbeginend' => 'Begin en einde markeren',
        'property_autoclosing' => 'Automatisch sluiten',
        'property_enabled' => 'Ingeschakeld',
        'property_disabled' => 'Uitgeschakeld',
        'property_soft_tabs' => 'Zachte tabs',
        'property_tab_size' => 'Tab grootte',
        'property_readonly' => 'Alleen-lezen',
        'property_use_default' => 'Standaard instelling',
        'property_options' => 'Opties',
        'property_prompt' => 'Invoer',
        'property_prompt_description' => 'Tekst op de toevoegknop.',
        'property_prompt_default' => 'Nieuw item',
        'property_available_colors' => 'Beschikbare kleuren',
        'property_available_colors_description' => 'Lijst van beschikbare kleuren in HEX formaat (#FF0000). Laat leeg voor standaard kleuren set. Een waarde per regel.',
        'property_datepicker_mode' => 'Modus',
        'property_datepicker_mode_date' => 'Datum',
        'property_datepicker_mode_datetime' => 'Datum en tijd',
        'property_datepicker_mode_time' => 'Tijd',
        'property_datepicker_min_date' => 'Minimale datum',
        'property_datepicker_min_date_description' => 'De minimale datum die geselecteerd kan worden. Laat leeg om de standaardwaarde te gebruiken (2000-01-01).',
        'property_datepicker_max_date' => 'Maximale datum',
        'property_datepicker_max_date_description' => 'De maximale datum die geselecteerd kan worden. Laat leeg om de standaardwaarde te gebruiken (2020-12-31).',
        'property_datepicker_date_invalid_format' => 'Ongeldig datum formaat. Gebruik het formaat YYYY-MM-DD.',
        'property_markdown_mode' => 'Modus',
        'property_markdown_mode_split' => 'Gesplitst',
        'property_markdown_mode_tab' => 'Tabblad',
        'property_fileupload_mode' => 'Modus',
        'property_fileupload_mode_file' => 'Bestand',
        'property_fileupload_mode_image' => 'Afbeelding',
        'property_group_fileupload' => 'Bestandsupload',
        'property_fileupload_prompt' => 'Prompt',
        'property_fileupload_prompt_description' => 'Tekst op de upload knop. Alleen van toepassing op bestandsmodus (optioneel).',
        'property_fileupload_image_width' => 'Breedte afbeelding',
        'property_fileupload_image_width_description' => 'Afbeeldingen zullen geschaald worden naar deze breedte (optioneel).',
        'property_fileupload_invalid_dimension' => 'Ongeldige waarde voor breedte/hoogte afbeelding, geef een getal in.',
        'property_fileupload_image_height' => 'Hoogte afbeelding',
        'property_fileupload_image_height_description' => 'Afbeeldingen zullen geschaald worden naar deze hoogte (optioneel).',
        'property_fileupload_file_types' => 'Bestandstypes',
        'property_fileupload_file_types_description' => 'Komma gescheiden lijst van toegestane bestandsextenties, bijvoorbeeld: zip,txt (optioneel).',
        'property_fileupload_mime_types' => 'MIME typen',
        'property_fileupload_mime_types_description' => 'Komma gescheiden lijst van toegestane MIME-typen; bestandsextenties of volledige namen, bijvoorbeeld: zip,txt',
        'property_fileupload_use_caption' => 'Gebruik annotatie',
        'property_fileupload_use_caption_description' => 'Staat toe dat er een titel en omschrijving kunnen worden opgegeven voor het bestand.',
        'property_fileupload_thumb_options' => 'Miniatuurweergave opties',
        'property_fileupload_thumb_options_description' => 'Beheer opties voor de automatisch gegenereerde miniatuurweergaven. Alleen van toepassing bij Afbeelding modus.',
        'property_fileupload_thumb_mode' => 'Modus',
        'property_fileupload_thumb_auto' => 'Automatisch',
        'property_fileupload_thumb_exact' => 'Exact',
        'property_fileupload_thumb_portrait' => 'Staand',
        'property_fileupload_thumb_landscape' => 'Liggend',
        'property_fileupload_thumb_crop' => 'Uitsnijden',
        'property_fileupload_thumb_extension' => 'Bestandsextentie',
        'property_name_from' => 'Kolomnaam',
        'property_name_from_description' => 'Gerelateerde kolomnaam die gebruikt moet worden voor het weergeven van een naam.',
        'property_description_from' => 'Omschrijving kolom',
        'property_description_from_description' => 'Gerelateerde kolomnaam die gebruikt moet worden voor het weergeven van een omschrijving.',
        'property_recordfinder_prompt' => 'Prompt',
        'property_recordfinder_prompt_description' => 'Text to display when there is no record selected. The %s character represents the search icon. Leave empty for the default prompt.',
        'property_recordfinder_list' => 'Lijst configuratie',
        'property_recordfinder_list_description' => 'Een referentie naar een lijstkolom definitie bestand. Gebruik het $ symbool om te refereren naar de plugin map, bijvoorbeeld: $/acme/blog/lists/_list.yaml',
        'property_recordfinder_list_required' => 'Geef een pad op naar het YAML bestand',
        'property_group_recordfinder' => 'Record zoeker',
        'property_mediafinder_mode' => 'Modus',
        'property_mediafinder_mode_file' => 'Bestand',
        'property_mediafinder_mode_image' => 'Afbeelding',
        'property_mediafinder_prompt' => 'Prompt',
        'property_mediafinder_prompt_description' => 'Tekst om weer te geven als er geen item geselecteerd is. Het karakter %s representeerd het media beheer icoon. Laat leeg voor de standaard prompt.',
        'property_group_relation' => 'Relatie',
        'property_relation_select' => 'kiezen',
        'property_relation_select_description' => 'CONCAT meerdere kolommen samen voor het weergeven van een naam',
        'property_relation_prompt' => 'Prompt',
        'property_relation_prompt_description' => 'Tekst om weer te geven als er geen selecties beschikbaar zijn.',
        'property_max_items' => 'Maximum aantal',
        'property_max_items_description' => 'Maximum toegelaten aantal items in de herhaler.',
        'control_group_standard' => 'Standaard',
        'control_group_widgets' => 'Widgets',
        'click_to_add_control' => 'Element toevoegen',
        'loading' => 'Bezig met laden...',
        'control_text' => 'Tekst',
        'control_text_description' => 'Invoerveld voor één regel tekst.',
        'control_password' => 'Wachtwoord',
        'control_password_description' => 'Invoerveld voor een wachtwoord.',
        'control_checkbox' => 'Keuzevakje',
        'control_checkbox_description' => 'Enkelvoudig keuzevakje.',
        'control_switch' => 'Schakelaar',
        'control_switch_description' => 'Enkelvoudige schakelaar, een alternatief voor het keuzevakje.',
        'control_textarea' => 'Tekst',
        'control_textarea_description' => 'Tekstvak voor meerdere regels met instelbare hoogte.',
        'control_dropdown' => 'Selectieveld',
        'control_dropdown_description' => 'Een selectie lijst met vaste of dynamische opties.',
        'control_unknown' => 'Onbekend element type: :type',
        'control_repeater' => 'Herhaler',
        'control_repeater_description' => 'Toont een set van herhalende formulier elementen.',
        'control_number' => 'Nummer',
        'control_number_description' => 'Invoerveld voor een nummer.',
        'control_hint' => 'Tip',
        'control_hint_description' => 'Toont een tip in een vakje die verborgen kan worden door een gebruiker.',
        'control_partial' => 'Partial',
        'control_partial_description' => 'Toont inhoud van een zgn. partial.',
        'control_section' => 'Sectie',
        'control_section_description' => 'Toont een formuliersectie met een kop- en subkoptekst.',
        'control_radio' => 'Lijst van invoerrondjes',
        'control_radio_description' => 'Een lijst van invoerrondjes, er kan maar één invoerrondje geselecteerd worden.',
        'control_radio_option_1' => 'Optie 1',
        'control_radio_option_2' => 'Optie 2',
        'control_checkboxlist' => 'Lijst van keuzevakjes',
        'control_checkboxlist_description' => 'Een lijst van keuzevakjes, er kunnen meerdere keuzevakjes geselecteerd worden.',
        'control_codeeditor' => 'Code editor',
        'control_codeeditor_description' => 'Een editor voor het bewerken van geformatteerde code of opmaakcode.',
        'control_colorpicker' => 'Kleur kiezer',
        'control_colorpicker_description' => 'Een veld met de mogelijkheid voor het selecteren van een hexadecimale kleurcode.',
        'control_datepicker' => 'Datum kiezer',
        'control_datepicker_description' => 'Een veld met de mogelijkheid voor het selecteren van een datum en tijd.',
        'control_richeditor' => 'WYSIWYG editor',
        'control_richeditor_description' => 'Een editor voor het bewerken van uitgebreide opgemaakte tekst.',
        'control_markdown' => 'Markdown editor',
        'control_markdown_description' => 'Een editor voor het bewerken van tekst in het Markdown formaat.',
        'control_fileupload' => 'Bestand uploader',
        'control_fileupload_description' => 'Een bestandsuploader voor afbeeldingen of reguliere bestanden.',
        'control_recordfinder' => 'Record veld',
        'control_recordfinder_description' => 'Een zoekveld met details van een gerelateerd record.',
        'control_mediafinder' => 'Media veld',
        'control_mediafinder_description' => 'Een veld die een item uit de Media bibliotheek kan bevatten.',
        'control_relation' => 'Relatie',
        'control_relation_description' => 'Toont een selectieveld of een lijst van keuzevakjes om een gerelateerd record te selecteren.',
        'error_file_name_required' => 'Voer bestandsnaam in van het formulier.',
        'error_file_name_invalid' => 'Bestandsnaam kan alleen latijnse karakters, cijfers of een van de volgende tekens bevatten: _ - #',
        'span_left' => 'Links',
        'span_right' => 'Rechts',
        'span_full' => 'Volledige breedte',
        'span_auto' => 'Automatisch',
        'empty_tab' => 'Leeg tabblad',
        'confirm_close_tab' => 'Het tabblad bevat elementen die verwijderd zullen worden. Doorgaan?',
        'tab' => 'Formulier tabblad',
        'tab_title' => 'Titel',
        'controls' => 'Elementen',
        'property_tab_title_required' => 'De titel van het tabblad is verplicht.',
        'tabs_primary' => 'Primaire tabs',
        'tabs_secondary' => 'Secundaire tabs',
        'tab_stretch' => 'Uitrekken',
        'tab_stretch_description' => 'Met deze optie geef je aan dat de inhoud van het tabblad meerekt naar de hoogte van het bovenliggende element.',
        'tab_css_class' => 'CSS class',
        'tab_css_class_description' => 'Wijst een CSS class toe aan de inhoud van het tabblad.',
        'tab_name_template' => 'Tabblad %s',
        'tab_already_exists' => 'Tabblad met opgegeven titel bestaat reeds.',
    ],
    'list' => [
        'tab_new_list' => 'Nieuwe lijst',
        'saved' => 'De lijst is succesvol opgeslagen.',
        'confirm_delete' => 'Weet je zeker dat je de lijst wilt verwijderen?',
        'tab_columns' => 'Kolommen',
        'btn_add_column' => 'Kolom toevoegen',
        'btn_delete_column' => 'Kolom verwijderen',
        'column_dbfield_label' => 'Veld',
        'column_dbfield_required' => 'Geef Model veld op',
        'column_name_label' => 'Label',
        'column_label_required' => 'Geef kolom label op',
        'column_type_label' => 'Type',
        'column_type_required' => 'Geef kolomtype op',
        'column_type_text' => 'Tekst',
        'column_type_number' => 'Numeriek',
        'column_type_switch' => 'Schakelaar',
        'column_type_datetime' => 'Datum & Tijd',
        'column_type_date' => 'Datum',
        'column_type_time' => 'Tijd',
        'column_type_timesince' => 'Datum & tijd sinds',
        'column_type_timetense' => 'Datum & tijd afgekort',
        'column_type_select' => 'Keuze',
        'column_type_partial' => 'Partial',
        'column_label_default' => 'Standaard',
        'column_label_searchable' => 'Zoeken',
        'column_label_sortable' => 'Sorteerbaar',
        'column_label_invisible' => 'Onzichtbaar',
        'column_label_select' => 'Select',
        'column_label_relation' => 'Relatie',
        'column_label_css_class' => 'CSS class',
        'column_label_width' => 'Breedte',
        'column_label_path' => 'Pad',
        'column_label_format' => 'Formaat',
        'column_label_value_from' => 'Waarde van',
        'error_duplicate_column' => "Kolom veldnaam bestaat reeds: ':column'.",
    ],
    'controller' => [
        'menu_label' => 'Controllers',
        'no_records' => 'Geen controllers aanwezig',
        'controller' => 'Controller',
        'behaviors' => 'Behaviors',
        'new_controller' => 'Nieuwe controller',
        'error_controller_has_no_behaviors' => 'De controller heeft geen configureerbare behaviors.',
        'error_invalid_yaml_configuration' => 'Fout bij laden behavior configuratie bestand: :file',
        'behavior_form_controller' => 'Formulier controller behavior',
        'behavior_form_controller_description' => 'Voegt formulier functionaliteit toe aan een back-end pagina. Deze behavior bevat drie pagina\'s: Create (aanmaken), Update (wijzigen) en Preview (voorbeeldweergave).',
        'property_behavior_form_placeholder' => '-- Selecteer formulier --',
        'property_behavior_form_name' => 'Naam',
        'property_behavior_form_name_description' => 'De naam van het object wat beheerd wordt door dit formulier.',
        'property_behavior_form_name_required' => 'Geef de naam van het formulier op',
        'property_behavior_form_file' => 'Formulier configuratie',
        'property_behavior_form_file_description' => 'Referentie naar het formulieren veld definitie bestand.',
        'property_behavior_form_file_required' => 'Geef het pad op naar het configuratiebestand van het formulier',
        'property_behavior_form_model_class' => 'Model class',
        'property_behavior_form_model_class_description' => 'Klassenaam van een model, de data van het formulier wordt geladen en opgeslagen met dit model.',
        'property_behavior_form_model_class_required' => 'Selecteer een model class',
        'property_behavior_form_default_redirect' => 'Standaard redirect',
        'property_behavior_form_default_redirect_description' => 'De standaard pagina waarnaar verwezen wordt nadat het formulier is opgeslagen.',
        'property_behavior_form_create' => 'Maak record pagina',
        'property_behavior_form_redirect' => 'Redirect',
        'property_behavior_form_redirect_description' => 'Een pagina waarnaar verwezen wordt wanneer een record is aangemaakt.',
        'property_behavior_form_redirect_close' => 'Sluiten redirect',
        'property_behavior_form_redirect_close_description' => 'Een pagina waarnaar verwezen wordt wanneer er gekozen is voor \'Opslaan en sluiten\'.',
        'property_behavior_form_flash_save' => 'Bericht bij opslaan',
        'property_behavior_form_flash_save_description' => 'Bericht om weer te geven nadat een record is opgeslagen.',
        'property_behavior_form_page_title' => 'Paginatitel',
        'property_behavior_form_update' => 'Record bijwerken pagina',
        'property_behavior_form_update_redirect' => 'Redirect',
        'property_behavior_form_create_redirect_description' => 'Een pagina waarnaar verwezen wordt als een record wordt opgeslagen.',
        'property_behavior_form_flash_delete' => 'Delete flash message',
        'property_behavior_form_flash_delete_description' => 'Flash message to display when record is deleted.',
        'property_behavior_form_preview' => 'Voorbeeldweergave record pagina',
        'behavior_list_controller' => 'Lijst controller behavior',
        'behavior_list_controller_description' => 'Stelt een sorteerbare en doorzoekbare lijst beschikbaar. De \'behavior\' maakt de controller action "index" beschikbaar.',
        'property_behavior_list_title' => 'Titel lijst',
        'property_behavior_list_title_required' => 'Geeft de titel van de lijst op',
        'property_behavior_list_placeholder' => '-- Selecteer lijst --',
        'property_behavior_list_model_class' => 'Model class',
        'property_behavior_list_model_class_description' => 'Klassenaam van een model, de lijst wordt geladen m.b.v. dit model.',
        'property_behavior_form_model_class_placeholder' => '-- Selecteer model --',
        'property_behavior_list_model_class_required' => 'Selecteer een model class',
        'property_behavior_list_model_placeholder' => '-- Selecteer model --',
        'property_behavior_list_file' => 'Configuratiebestand lijst',
        'property_behavior_list_file_description' => 'Referentie naar een definitiebestand van een lijst.',
        'property_behavior_list_file_required' => 'Geeft het pad op naar het configuratiebestand van de lijst',
        'property_behavior_list_record_url' => 'Record URL',
        'property_behavior_list_record_url_description' => 'Koppel elk record van de lijst aan een andere pagina. Bijv. users/update:id. Het :id gedeelte wordt vervangen met het identificatie nummer van het record.',
        'property_behavior_list_no_records_message' => 'Bericht bij geen records',
        'property_behavior_list_no_records_message_description' => 'Het bericht wat moet worden weergegeven als er geen records gevonden zijn.',
        'property_behavior_list_recs_per_page' => 'Records per pagina',
        'property_behavior_list_recs_per_page_description' => 'Aantal records wat weergegeven moet worden per pagina. Geef 0 op om geen paginatie te gebruiken. Standaardwaarde: 0',
        'property_behavior_list_recs_per_page_regex' => 'Het aantal records per pagina moet een numerieke waarde zijn',
        'property_behavior_list_show_setup' => 'Toon setup knop',
        'property_behavior_list_show_sorting' => 'Toon sorteren',
        'property_behavior_list_default_sort' => 'Standaard sortering',
        'property_behavior_form_ds_column' => 'Kolom',
        'property_behavior_form_ds_direction' => 'Richting',
        'property_behavior_form_ds_asc' => 'Oplopend',
        'property_behavior_form_ds_desc' => 'Aflopend',
        'property_behavior_list_show_checkboxes' => 'Toon keuzevakjes',
        'property_behavior_list_onclick' => 'Klik handler',
        'property_behavior_list_onclick_description' => 'JavaScript code wat uitgevoerd moet worden als er op een record wordt geklikt.',
        'property_behavior_list_show_tree' => 'Toon hiërarchie',
        'property_behavior_list_show_tree_description' => 'Toont een hiërarchie boom voor ouder/kind-records.',
        'property_behavior_list_tree_expanded' => 'Uitgeklapte weergave',
        'property_behavior_list_tree_expanded_description' => 'Geeft aan of de hiërarchische boom standaard uitgeklapt moet worden weergegeven.',
        'property_behavior_list_toolbar' => 'Toolbar',
        'property_behavior_list_toolbar_buttons' => 'Knoppen partial bestand',
        'property_behavior_list_toolbar_buttons_description' => 'Referentie naar een partial bestand met de toolbar knoppen. Bijv. list_toolbar',
        'property_behavior_list_search' => 'Zoeken',
        'property_behavior_list_search_prompt' => 'Zoek prompt',
        'property_behavior_list_filter' => 'Filter configuratie',
        'behavior_reorder_controller' => 'Reorder controller behavior',
        'behavior_reorder_controller_description' => 'Stelt functies beschikbaar voor het sorteren en rangschikken van records. De behavior maakt automatisch de "reorder" controller actie aan.',
        'property_behavior_reorder_title' => 'Rangschik titel',
        'property_behavior_reorder_title_required' => 'De rangschik titel is verplicht.',
        'property_behavior_reorder_name_from' => 'Attribuut naam',
        'property_behavior_reorder_name_from_description' => 'Attribuut van het model wat als weergavenaam van het record moet worden gebruikt.',
        'property_behavior_reorder_name_from_required' => 'De attribuut naam is verplicht.',
        'property_behavior_reorder_model_class' => 'Model class',
        'property_behavior_reorder_model_class_description' => 'Model klassenaam, de rangschik data wordt geladen uit dit model.',
        'property_behavior_reorder_model_class_placeholder' => '-- Selecteer model --',
        'property_behavior_reorder_model_class_required' => 'Selecteer een model class',
        'property_behavior_reorder_model_placeholder' => '-- Selecteer model --',
        'property_behavior_reorder_toolbar' => 'Toolbar',
        'property_behavior_reorder_toolbar_buttons' => 'Knoppen partial bestand',
        'property_behavior_reorder_toolbar_buttons_description' => 'Referentie naar een partial bestand met de toolbar knoppen. Bijv. reorder_toolbar',
        'error_controller_not_found' => 'Het originele controller bestand kan niet gevonden worden.',
        'error_invalid_config_file_name' => 'De bestandsnaam van configuratiebestand :fil) (van behavior :class) bevat ongeldige karakters en kan daarom niet worden geladen.',
        'error_file_not_yaml' => 'Het configuratiebestad :file (van behavior :class) is geen YAML-bestand. Alleen YAML-bestanden worden ondersteund.',
        'saved' => 'De controller is succesvol opgeslagen.',
        'controller_name' => 'Naam controller',
        'controller_name_description' => 'De naam van de controller bepaald de uiteindelijk URL waarmee de controller beschikbaar is in de back-end. De standaard PHP conventies zijn van toepassing. Het eerste karakter moet een hoofdletter zijn. Voorbeelden van geldige namen: Categories, Posts of Products.',
        'base_model_class' => 'Basis model class',
        'base_model_class_description' => 'Selecteer een model class om te gebruiken als basis model in behaviors die models vereisen of ondersteunen. Je kan de behaviors later configureren.',
        'base_model_class_placeholder' => '-- Selecteer model --',
        'controller_behaviors' => 'Behaviors',
        'controller_behaviors_description' => 'Seleteer de behaviors die de controller moet implementeren. De view bestanden, die vereist zijn voor de behaviors, zullen automatisch worden aangemaakt.',
        'controller_permissions' => 'Toegangsrechten',
        'controller_permissions_description' => 'Selecteer de gebruikersrechten die toegang hebben tot de controller view. Toegangsrechten kunnen aangemaakt worden via het tabblad Toegangsrechten in het linkermenu. Je kunt deze optie ook later aanpassen in de PHP-code van de controller.',
        'controller_permissions_no_permissions' => 'De plugin heeft (nog) geen toegangsrechten gedefinieerd.',
        'menu_item' => 'Actief menu item',
        'menu_item_description' => 'Selecteer een menu item dat geactiveerd moet worden voor de pagina\'s van deze controller. Je kunt deze optie ook later aanpassen in de PHP-code van de controller.',
        'menu_item_placeholder' => '-- Selecteer menu item --',
        'error_unknown_behavior' => 'De behavior class :class is niet geregistreerd in de behavior bibliotheek.',
        'error_behavior_view_conflict' => 'De geselecteerde behaviors leveren conflicterende views (:view) en kunnen daarom niet samen worden gebruikt in een controller.',
        'error_behavior_config_conflict' => 'De geselecteerde behaviors leveren conflicterende configuratiebestanden op (:file) en kunnen daarom niet samen worden gebruikt in een controller.',
        'error_behavior_view_file_not_found' => 'De view template :view van behavior :class kan niet worden gevonden.',
        'error_behavior_config_file_not_found' => 'Het configuratiebestand template :file van behavior :class kan niet worden gevonden.',
        'error_controller_exists' => 'Het controller bestand :file bestaat reeds.',
        'error_controller_name_invalid' => 'Ongeldigde controllernaam. Voorbeelden van geldige namen: Posts, Categories of Products.',
        'error_behavior_view_file_exists' => 'De view :view bestaat reeds voor deze controller.',
        'error_behavior_config_file_exists' => 'Het behavior configuratiebestand: file bestaat reeds.',
        'error_save_file' => 'Fout bij opslaan van het controller bestand :file.',
        'error_behavior_requires_base_model' => 'Er moet een basis model class worden geselecteer voor behavior :behavior.',
        'error_model_doesnt_have_lists' => 'Het geselecteerde model heeft geen lijsten. Maak eerst een lijst.',
        'error_model_doesnt_have_forms' => 'Het geselecteerde model heeft geen formulieren. Maak eerst een formulier.',
    ],
    'version' => [
        'menu_label' => 'Versies',
        'no_records' => 'Geen plugin versies aanwezig',
        'search' => 'Zoeken...',
        'tab' => 'Versies',
        'saved' => 'De versie is succesvol opgeslagen.',
        'confirm_delete' => 'Weet je zeker dat je deze versie wilt verwijderen?',
        'tab_new_version' => 'Nieuwe versie',
        'migration' => 'Migratie',
        'seeder' => 'Seeder',
        'custom' => 'Versienummer ophogen',
        'apply_version' => 'Versie toepassen',
        'applying' => 'Bezig met toepassen...',
        'rollback_version' => 'Versie terugzetten',
        'rolling_back' => 'Bezig met terugzerren...',
        'applied' => 'De versie is succesvol toegepast.',
        'rolled_back' => 'De versie is succesvol teruggezet.',
        'hint_save_unapplied' => 'Je hebt een nog niet geactiveerde versie opgeslagen. Niet geactiveerde versies kunnen automatisch worden geactiveerd als jij of een andere gebruiker inlogd op de back-end. Of als een database tabel wordt opgeslagen binnen de Database sectie van de Builder plugin.',
        'hint_rollback' => 'Het terugzetten van een versie zal ook alle versies nieuwer dan deze versie terugzetten. Wees je ervan bewust dat niet geactiveerde versies automatisch geactiveerd kunnen worden, als jij of een andere gebruiker inlogd op de back-end. Of als een database tabel wordt opgeslagen binnen de Database sectie van de Builder plugin.',
        'hint_apply' => 'Het activeren van een versie zal ook oudere niet geactiveerde versies activeren.',
        'dont_show_again' => 'Laat niet meer zien',
        'save_unapplied_version' => 'Niet geactiveerde versie opslaan',
    ],
    'menu' => [
        'menu_label' => 'Backend menu',
        'tab' => 'Menu\'s',
        'items' => 'Menu items',
        'saved' => 'De menu\'s zijn succesvol opgeslagen.',
        'add_main_menu_item' => 'Hoofdmenu item toevoegen',
        'new_menu_item' => 'Menu item',
        'add_side_menu_item' => 'Sub-item toevoegen',
        'side_menu_item' => 'Linker menu item',
        'property_label' => 'Label',
        'property_label_required' => 'Voer label in van menu item.',
        'property_url_required' => 'Voer URL in van menu item.',
        'property_url' => 'URL',
        'property_icon' => 'Icoon',
        'property_icon_required' => 'Selecteer een icoon.',
        'property_permissions' => 'Toegangsrechten',
        'property_order' => 'Volgorde',
        'property_order_invalid' => 'Geef de volgorde aan met een getal.',
        'property_order_description' => 'De volgorde bepaalde de positie van het menu item. Als de volgorde niet is opgegeven zal het item aan het einde van het menu worden toegevoegd. De standaardwaarden van de volgordes worden elke keer opgehoogd met 100.',
        'property_attributes' => 'HTML attributen',
        'property_code' => 'Code',
        'property_code_invalid' => 'De code mag alleen bestaan uit letters en cijfers.',
        'property_code_required' => 'Geef menu item code op.',
        'error_duplicate_main_menu_code' => "Dupliceer hoofdmenu item code: ':code'.",
        'error_duplicate_side_menu_code' => "Dupliceer linker menu item code: ':code'.",
    ],
    'localization' => [
        'menu_label' => 'Vertalen',
        'language' => 'Taal',
        'strings' => 'Taallabels',
        'confirm_delete' => 'Weet je zeker dat je deze taal wilt verwijderen?',
        'tab_new_language' => 'Nieuwe taal',
        'no_records' => 'Geen talen aanwezig',
        'saved' => 'Het taalbestand is succesvol opgeslagen.',
        'error_cant_load_file' => 'Kan het taalbestand niet laden, bestand is niet gevonden.',
        'error_bad_localization_file_contents' => 'Kan het taalbestand niet laden. Taalbestanden kunnen alleen array-definities en teksten bevatten.',
        'error_file_not_array' => 'Kan het taalbestand niet laden. Taalbestanden moeten een array teruggeven.',
        'save_error' => "Fout bij opslaan van bestand ':name'. Controleer schrijfrechten.",
        'error_delete_file' => 'Fout bij verwijderen van taalbestand.',
        'add_missing_strings' => 'Toevoegen van ontbrekende taallabels.',
        'copy' => 'Kopiëren',
        'add_missing_strings_label' => 'Selecteer een taal waarvan de taallabels gekopiëerd moeten worden.',
        'no_languages_to_copy_from' => 'Er zijn geen andere talen waar de taallabels van gekopiëerd kunnen worden.',
        'new_string_warning' => 'Nieuwe taallabel of sectie',
        'structure_mismatch' => 'De structuur van het bron taalbestand komt niet overeen met het bestand wat nu wordt gewijzigd. Een aantal taallabels in het gewijzigde bestand corresponderen met secties in het bronbestand (of vice versa) en kunnen daarom niet automatisch worden samengevoegd.',
        'create_string' => 'Nieuw taallabel toevoegen',
        'string_key_label' => 'Taallabel ID',
        'string_key_comment' => 'Geef het taallabel ID op gescheiden met een punt, bijvoorbeeld: plugin.search. De taallabel zal worden aangemaakt in het standaard taalbestand van de plugin.',
        'string_value' => 'Taallabel waarde',
        'string_key_is_empty' => 'Het taallabel ID mag niet leeg zijn.',
        'string_value_is_empty' => 'Taallabel waarde mag niet leeg zijn.',
        'string_key_exists' => 'Het taallabel ID bestaat reeds. Geef een ander ID op.',
    ],
    'permission' => [
        'menu_label' => 'Toegangsrechten',
        'tab' => 'Toegangsrechten',
        'form_tab_permissions' => 'Toegangsrechten',
        'btn_add_permission' => 'Toegangsrechten toevoegen',
        'btn_delete_permission' => 'Toegangsrechten verwijderen',
        'column_permission_label' => 'Code',
        'column_permission_required' => 'Geef de code op.',
        'column_tab_label' => 'Tabblad titel',
        'column_tab_required' => 'Geef tabblad titel op.',
        'column_label_label' => 'Label',
        'column_label_required' => 'Geef een label op.',
        'saved' => 'Toegangsrechten zijn succesvol opgeslagen.',
        'error_duplicate_code' => "Dupliceer code: ':code'.",
    ],
    'yaml' => [
        'save_error' => "Fout bij opslaan bestan ':name'. Controleer schrijfrechten.",
    ],
    'common' => [
        'error_file_exists' => "Het bestand bestaat reeds: ':path'.",
        'field_icon_description' => 'OctoberCMS gebruikt Font Autumn iconen, zie: http://octobercms.com/docs/ui/icon',
        'destination_dir_not_exists' => "De doel directory bestaat niet: ':path'.",
        'error_make_dir' => "Fout bij aanmaken van directory: ':name'.",
        'error_dir_exists' => "Directory bestaat reeds: ':path'.",
        'template_not_found' => "Template-bestand kan niet worden gevonden: ':name'.",
        'error_generating_file' => "Fout bij genreren van bestand: ':path'.",
        'error_loading_template' => "Fout bij laden van template-bestand: ':name'.",
        'select_plugin_first' => 'Selecteer eerst een plugin. Om een lijst van plugins te tonen, klik op het > icoon in de linker zijbalk.',
        'plugin_not_selected' => 'Plugin is niet geselecteerd.',
        'add' => 'Toevoegen',
    ],
    'migration' => [
        'entity_name' => 'Migratie',
        'error_version_invalid' => 'Het versienummer moet voldoen aan het formaat 1.0.1',
        'field_version' => 'Versie',
        'field_description' => 'Omschrijving',
        'field_code' => 'Code',
        'save_and_apply' => 'Opslaan & toepassen',
        'error_version_exists' => 'De migratie-versie bestaat reeds.',
        'error_script_filename_invalid' => 'De bestandsnaam van de migratie kan alleen letters, getallen en underscores bevatten. De naam moet beginnen met een letter en mag geen spaties bevatten.',
        'error_cannot_change_version_number' => 'Kan het versienummer niet aanpassen voor een reeds toegepaste versie.',
        'error_file_must_define_class' => 'De migratie code moet een migratie of een seeder class definieren. Laat het code veld leeg als je alleen het versienummer wilt bijwerken.',
        'error_file_must_define_namespace' => 'De migratie code moet een namespace definieren. Laat het code veld leeg als je alleen het versienummer wilt bijwerken.',
        'no_changes_to_save' => 'Er zijn geen wijzigingen om op te slaan.',
        'error_namespace_mismatch' => 'The migratie code moet de plugin namespace :namespace gebruiken.',
        'error_migration_file_exists' => 'Het migratie bestand :file bestaat reeds. Gebruik een andere klasse naam.',
        'error_cant_delete_applied' => 'Deze versie is reeds toegepast en kan daarom niet worden verwijderd. Ga eerst terug naar deze versie (rollback).',
    ],
    'components' => [
        'list_title' => 'Record lijst',
        'list_description' => 'Toont een lijst van records voor geselecteerde model.',
        'list_page_number' => 'Paginanummer',
        'list_page_number_description' => 'De waarde hiervan wordt gebruikt om te bepalen op welke pagina de gebruiker zit.',
        'list_records_per_page' => 'Records per pagina',
        'list_records_per_page_description' => 'Het aantal records wat per pagina moet worden weergegeven. Laat leeg om paginatie uit te schakelen.',
        'list_records_per_page_validation' => 'Ongeldige waarde. Het aantal records per pagina moet worden aangegeven met een nummer.',
        'list_no_records' => 'Bericht bij geen records',
        'list_no_records_description' => 'Bericht wat moet worden weergegeven als er geen records zijn.',
        'list_no_records_default' => 'Geen records gevonden',
        'list_sort_column' => 'Sorteer op kolom',
        'list_sort_column_description' => 'Kolom van model waarop de records gesorteerd moeten worden.',
        'list_sort_direction' => 'Sorteerrichting',
        'list_display_column' => 'Weergave kolom',
        'list_display_column_description' => 'Kolom die moet worden weergegeven in de lijst.',
        'list_display_column_required' => 'Selecteer een weergave kolom.',
        'list_details_page' => 'Detailpagina',
        'list_details_page_description' => 'Pagina waarop record details worden weergegeven.',
        'list_details_page_no' => '-- Geen detailpagina --',
        'list_sorting' => 'Sortering',
        'list_pagination' => 'Paginatie',
        'list_order_direction_asc' => 'Oplopend',
        'list_order_direction_desc' => 'Aflopend',
        'list_model' => 'Model class',
        'list_scope' => 'Scope',
        'list_scope_description' => 'Model scope waarin de records moeten worden opgevraagd (optioneel).',
        'list_scope_default' => '-- Selecteer een scope (optioneel) --',
        'list_details_page_link' => 'Link naar de detailpagina',
        'list_details_key_column' => 'Detail sleutelkolom',
        'list_details_key_column_description' => 'Model kolom die moet worden gebruikt als record ID in de detailpagina links.',
        'list_details_url_parameter' => 'URL parameter naam',
        'list_details_url_parameter_description' => 'Naam van de detailpagina URL parameter. De parameter bevat het record ID.',
        'details_title' => 'Record details',
        'details_description' => 'Toont record details voor een geselecteerd model.',
        'details_model' => 'Model class',
        'details_identifier_value' => 'ID-waarde',
        'details_identifier_value_description' => 'ID-waarde waarmee het record wordt opgevraagd uit de database. Geef een vaste waarde op of een parameter naam voor in de URL.',
        'details_identifier_value_required' => 'De ID-waarde mag niet leeg zijn.',
        'details_key_column' => 'Sleutelkolom',
        'details_key_column_description' => 'De kolom die gebruikt moet worden om het record (met ID-waarde) uit de database te kunnen opvragen.',
        'details_key_column_required' => 'De sleutelkolom mag niet leeg zijn.',
        'details_display_column' => 'Weergave kolom',
        'details_display_column_description' => 'De kolom uit het model die moet worden weergegeven op de detailpagina.',
        'details_display_column_required' => 'Selecteer de weergave kolom.',
        'details_not_found_message' => 'Bericht voor niet gevonden',
        'details_not_found_message_description' => 'Bericht wat moet worden weergegeven als het record niet is gevonden.',
        'details_not_found_message_default' => 'Record niet gevonden',
    ],
];
